require( "quest/mg_clothing/convout.lua" );
require( "quest/activity_mode/activity_common.lua" );
combine_speech_tables();

round_num = 
{
	5, -- round one
	5, -- round two
	ACTIVITY_LEVEL_MAX, -- activity mode -- quest/activity_mode/activity_timer.lua
};

function get_activity_bonus_time(level)
	return MINUTES(1) + SECONDS(0) + SECONDS(20)*level;
end

clothes_depth = 5;
clothes_moving_depth = 10;
moving_actor = nil;

initial_setup = true;
show_activity_text = false;

activity_data = { }

--clothing properties tables
clothing_type_table =
{
	-- note 'hotspot' affects the offset of the mesh, and the values below
	-- are the same as those in the process.bat of the pieces files for the clothing
	{ name = "shirt1", hotspot = { x = 34, y = 6 } },
	{ name = "pants1", hotspot = { x = 32, y = 6 } },
	{ name = "skirt1", hotspot = { x = 38, y = 6 } },
	{ name = "shirt2", hotspot = { x = 34, y = 6 } },
	{ name = "pants2", hotspot = { x = 32, y = 6 } },
	{ name = "skirt2", hotspot = { x = 28, y = 6 } },
	{ name = "shirt3", hotspot = { x = 34, y = 6 } },
	{ name = "pants3", hotspot = { x = 32, y = 6 } },
	{ name = "skirt3", hotspot = { x = 38, y = 6 } },
}

clothing_colour_table =
{
	"red",
	"blue",
	"green",
	"yellow",
}

clothing_pattern_table =
{
	"solid",
	"dot",
	"flower",
	"stripe",
}

-- clothing items for various levels
local items = 
{
	 -- round 1
	{

--[[
		-- activity 1 original
		{
			columns = 2,
		
			clothes = 
			{
				{ TYPE =3, COLOUR = 2, PATTERN = 1}, { TYPE =1, COLOUR = 2, PATTERN = 1},
				{ TYPE =2, COLOUR = 1, PATTERN = 1}, { TYPE =2, COLOUR = 3, PATTERN = 1},
			},
			
			grid_x = 360,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
]]--

		-- activity 1
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =1, COLOUR = 4, PATTERN = 1 },{ TYPE =1, COLOUR = 4, PATTERN = 1 },
				{ TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 },{ TYPE =1, COLOUR = 4, PATTERN = 1 },
			};
			
			grid_x = 275,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 2
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =1, COLOUR = 4, PATTERN = 1 }, { TYPE =1, COLOUR = 2, PATTERN = 1 },{ TYPE =1, COLOUR = 1, PATTERN = 1 },
				{ TYPE =9, COLOUR = 2, PATTERN = 1 }, { TYPE =9, COLOUR = 1, PATTERN = 1 },{ TYPE =9, COLOUR = 3, PATTERN = 1 },
			};
			
			grid_x = 275,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 3
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =5, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 1, PATTERN = 1 },
				{ TYPE =4, COLOUR = 2, PATTERN = 1 }, { TYPE =4, COLOUR = 1, PATTERN = 1 }, { TYPE =5, COLOUR = 3, PATTERN = 1 },
			};
			
			grid_x = 275,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 4
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =7, COLOUR = 2, PATTERN = 1 }, { TYPE =8, COLOUR = 3, PATTERN = 1 }, { TYPE =8, COLOUR = 1, PATTERN = 1 }, { TYPE =8, COLOUR = 2, PATTERN = 1 },
				{ TYPE =7, COLOUR = 1, PATTERN = 1 }, { TYPE =7, COLOUR = 3, PATTERN = 1 }, { TYPE =7, COLOUR = 1, PATTERN = 1 }, { TYPE =8, COLOUR = 4, PATTERN = 1 }, 
			};
			
			grid_x = 210,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 5
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =2, COLOUR = 2, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, { TYPE =9, COLOUR = 4, PATTERN = 1 }, { TYPE =1, COLOUR = 4, PATTERN = 1 },
				{ TYPE =9, COLOUR = 1, PATTERN = 1 }, { TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 3, PATTERN = 1 }, 
			};
			
			grid_x = 210,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
	},
	
	-- AG20081112 - I think we only have one round?
	-- round 2
	{
		-- activity 1
		{
			columns = 2,
		
			clothes = 
			{
				{ TYPE =3, COLOUR = 2, PATTERN = 1}, { TYPE =2, COLOUR = 1, PATTERN = 1},
				{ TYPE =1, COLOUR = 2, PATTERN = 1}, { TYPE =2, COLOUR = 3, PATTERN = 1},
			},
			
			grid_x = 250,
			grid_y = 30,
			grid_w = 200,
			grid_h = 200,
			
			scale = 1.0,
			upscale = 1.2,
		},
		

	},
	
	-- activity mode
	{

		-- activity 1
		{
			columns = 3,
		
			clothes = 
			{
				{ TYPE =7, COLOUR = 2, PATTERN = 1}, { TYPE =7, COLOUR = 2, PATTERN = 1}, { TYPE =7, COLOUR = 2, PATTERN = 1},
				{ TYPE =5, COLOUR = 1, PATTERN = 1}, { TYPE =5, COLOUR = 1, PATTERN = 1}, { TYPE =5, COLOUR = 1, PATTERN = 1}, 
			},
			
			grid_x = 300,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},

		-- activity 2
		{
			columns = 3,
		
			clothes = 
			{
				{ TYPE =7, COLOUR = 2, PATTERN = 1}, { TYPE =7, COLOUR = 4, PATTERN = 1}, { TYPE =7, COLOUR = 2, PATTERN = 1},
				{ TYPE =5, COLOUR = 1, PATTERN = 1}, { TYPE =5, COLOUR = 4, PATTERN = 1}, { TYPE =5, COLOUR = 1, PATTERN = 1}, 
			},
			
			grid_x = 300,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 3
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =4, COLOUR = 3, PATTERN = 1 }, { TYPE =5, COLOUR = 2, PATTERN = 1 },{ TYPE =9, COLOUR = 4, PATTERN = 1 },
				{ TYPE =4, COLOUR = 1, PATTERN = 1 }, { TYPE =5, COLOUR = 1, PATTERN = 1 },{ TYPE =9, COLOUR = 3, PATTERN = 1 },
			};
			
			grid_x = 250,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 4
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =3, COLOUR = 3, PATTERN = 1 }, { TYPE =3, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 2, PATTERN = 1 },
				{ TYPE =1, COLOUR = 4, PATTERN = 1 }, { TYPE =1, COLOUR = 2, PATTERN = 1 }, { TYPE =8, COLOUR = 3, PATTERN = 1 },
			};
			
			grid_x = 250,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 5
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =9, COLOUR = 2, PATTERN = 1 }, { TYPE =4, COLOUR = 2, PATTERN = 1 }, { TYPE =4, COLOUR = 1, PATTERN = 1 }, { TYPE =9, COLOUR = 3, PATTERN = 1 },
				{ TYPE =5, COLOUR = 3, PATTERN = 1 }, { TYPE =5, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =9, COLOUR = 1, PATTERN = 1 }, 
			};
			
			grid_x = 210,
			grid_y = 120,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},

		-- activity 6
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 3, PATTERN = 1 },
				{ TYPE =8, COLOUR = 3, PATTERN = 1 }, { TYPE =8, COLOUR = 3, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 },
				{ TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 3, PATTERN = 1 },
				 
			};
			
			grid_x = 275,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 7
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 2, PATTERN = 1 },
				{ TYPE =3, COLOUR = 2, PATTERN = 1 }, { TYPE =1, COLOUR = 2, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 },
				{ TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 4, PATTERN = 1 },
				 
			};
			
			grid_x = 275,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		

		-- activity 8
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 4, PATTERN = 1 },
				{ TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =7, COLOUR = 2, PATTERN = 1 }, { TYPE =7, COLOUR = 2, PATTERN = 1 }, 
				{ TYPE =7, COLOUR = 2, PATTERN = 1 }, { TYPE =7, COLOUR = 2, PATTERN = 1 }, { TYPE =7, COLOUR = 2, PATTERN = 1 }, { TYPE =7, COLOUR = 2, PATTERN = 1 }, 
			
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},

		-- activity 9
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =1, COLOUR = 2, PATTERN = 1 }, { TYPE =2, COLOUR = 3, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 2, PATTERN = 1 },
				{ TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 2, PATTERN = 1 }, { TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, 
				{ TYPE =1, COLOUR = 3, PATTERN = 1 }, { TYPE =1, COLOUR = 3, PATTERN = 1 }, { TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, 
				
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 10
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =8, COLOUR = 4, PATTERN = 1 }, { TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =1, COLOUR = 4, PATTERN = 1 },
				{ TYPE =5, COLOUR = 2, PATTERN = 1 }, { TYPE =8, COLOUR = 2, PATTERN = 1 }, { TYPE =9, COLOUR = 1, PATTERN = 1 },
				{ TYPE =5, COLOUR = 3, PATTERN = 1 }, { TYPE =8, COLOUR = 1, PATTERN = 1 }, { TYPE =9, COLOUR = 3, PATTERN = 1 },
				 
			};
			
			grid_x = 275,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 11
		{
			columns = 3,
		
			clothes = 
			{
				{ TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =6, COLOUR = 1, PATTERN = 1 }, { TYPE =3, COLOUR = 3, PATTERN = 1 },
				{ TYPE =7, COLOUR = 4, PATTERN = 1 }, { TYPE =7, COLOUR = 3, PATTERN = 1 }, { TYPE =2, COLOUR = 3, PATTERN = 1 },
				{ TYPE =6, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 4, PATTERN = 1 },
				 
			};
			
			grid_x = 275,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 12
		{
			columns = 3,
			
			clothes = 
			{
				{ TYPE =3, COLOUR = 4, PATTERN = 3 }, { TYPE =3, COLOUR = 2, PATTERN = 4 }, { TYPE =6, COLOUR = 1, PATTERN = 2 },
				{ TYPE =3, COLOUR = 1, PATTERN = 2 }, { TYPE =4, COLOUR = 2, PATTERN = 4 }, { TYPE =4, COLOUR = 1, PATTERN = 2 },
				{ TYPE =5, COLOUR = 2, PATTERN = 4 }, { TYPE =5, COLOUR = 1, PATTERN = 2 }, { TYPE =4, COLOUR = 4, PATTERN = 3 },
				 
			};
			
			grid_x = 275,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},

		-- activity 13
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =4, COLOUR = 2, PATTERN = 1 }, { TYPE =9, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 }, { TYPE =4, COLOUR = 4, PATTERN = 1 },
				{ TYPE =9, COLOUR = 3, PATTERN = 1 }, { TYPE =4, COLOUR = 3, PATTERN = 1 }, { TYPE =9, COLOUR = 3, PATTERN = 1 }, { TYPE =9, COLOUR = 1, PATTERN = 1 }, 
				{ TYPE =9, COLOUR = 2, PATTERN = 1 }, { TYPE =4, COLOUR = 2, PATTERN = 1 }, { TYPE =9, COLOUR = 3, PATTERN = 1 }, { TYPE =4, COLOUR = 1, PATTERN = 1 }, 
			
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 14
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =1, COLOUR = 2, PATTERN = 1 }, { TYPE =2, COLOUR = 4, PATTERN = 1 }, { TYPE =3, COLOUR = 4, PATTERN = 1 }, { TYPE =1, COLOUR = 4, PATTERN = 1 },
				{ TYPE =3, COLOUR = 1, PATTERN = 1 }, { TYPE =1, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =3, COLOUR = 3, PATTERN = 1 }, 
				{ TYPE =3, COLOUR = 2, PATTERN = 1 }, { TYPE =1, COLOUR = 2, PATTERN = 1 }, { TYPE =2, COLOUR = 1, PATTERN = 1 }, { TYPE =2, COLOUR = 3, PATTERN = 1 }, 
			
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		-- activity 15
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =3, COLOUR = 2, PATTERN = 2 }, { TYPE =1, COLOUR = 2, PATTERN = 2 }, { TYPE =6, COLOUR = 1, PATTERN = 3 }, { TYPE =6, COLOUR = 3, PATTERN = 1 }, 
				{ TYPE =1, COLOUR = 2, PATTERN = 2 }, { TYPE =6, COLOUR = 4, PATTERN = 4 }, { TYPE =3, COLOUR = 4, PATTERN = 4 }, { TYPE =1, COLOUR = 4, PATTERN = 4 },
				{ TYPE =3, COLOUR = 1, PATTERN = 3 }, { TYPE =1, COLOUR = 1, PATTERN = 3 }, { TYPE =6, COLOUR = 1, PATTERN = 3 }, { TYPE =3, COLOUR = 3, PATTERN = 1 }, 

			
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		
		

	
		-- activity 16
		{
			columns = 4,
			
			clothes = 
			{
				{ TYPE =4, COLOUR = 4, PATTERN = 3 }, { TYPE =5, COLOUR = 4, PATTERN = 3 }, { TYPE =6, COLOUR = 3, PATTERN = 2 }, { TYPE =6, COLOUR = 1, PATTERN = 1 }, 
				{ TYPE =4, COLOUR = 3, PATTERN = 2 }, { TYPE =5, COLOUR = 3, PATTERN = 2 }, { TYPE =6, COLOUR = 3, PATTERN = 2 }, { TYPE =4, COLOUR = 1, PATTERN = 1 }, 
				{ TYPE =5, COLOUR = 4, PATTERN = 3 }, { TYPE =6, COLOUR = 2, PATTERN = 4 }, { TYPE =4, COLOUR = 2, PATTERN = 4 }, { TYPE =5, COLOUR = 2, PATTERN = 4 },
			
			};
			
			grid_x = 210,
			grid_y = 47,
			grid_w = 150,
			grid_h = 150,
			
			scale = 1.00,
			upscale = 1.2,
		},
		


	},
};

function setup_activity()
	local activityNum = game:Get("mg_clothing_activity_num");
	local activityRound = game:Get("mg_clothing_activity_round");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
	end
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
		
		if not activityMode then
			if activityNum == 1 and activityRound == 1 then
				help_panel_say_raw(scene:grabstring("tutorial_1"));
			else
				help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
			end
		end
	else
	end
	
	spawn_clothes();
	
	if not activityMode then
		spawn_button(hint_button_spec);
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	if not scene.CHECK_DISPLAY_BUTTON then
		spawn_button(check_display_button_spec);
	end
end;

function get_cross_spec( i )
	return
	{
		name = "cross" .. tostring(i);	
		halo = "";
		gfx = { image = "cross" };
		
		command = function(actor)
			actor:SetDepthValue( clothes_depth + 1 );
			actor:JumpToPoint( { x = -100, y = -100 } );
			actor:SetAlpha(1);			
		end
	}
end

function CheckDisplay(flo)
	local numItems = table.getn(activity_data.clothes);
	local num_cols = activity_data.columns;
	local num_rows = numItems / num_cols;
	local cross_num = 1;
	local crosses = { };
	local grid_cross_offset = { x = -40, y = 5 };
	
	-- start at the top left of the grid, checking right and down for items that aren't different
	for i = 1, numItems do
		local row = math.floor( ( i - 1 ) / num_cols ) + 1;
		local col = fmod( ( i - 1 ), num_cols ) + 1;
		
		-- check right if not at the end
		if col <  num_cols then
			if not clothes_different( activity_data.grid[i].actor, activity_data.grid[ i + 1 ].actor ) then
				local cross_location = 
				{
					x = ((activity_data.grid[i].x + activity_data.grid[i + 1].x) / 2) + grid_cross_offset.x;
					y = ((activity_data.grid[i].y + activity_data.grid[i + 1].y) / 2) + grid_cross_offset.y;
				}
				crosses[cross_num] = scene:Spawn( get_cross_spec( cross_num ) )
				crosses[cross_num]:JumpToPoint( cross_location );
				cross_num = cross_num + 1;
			end
		end
		-- check down if not at the bottom
		if row < num_rows then
			if not clothes_different( activity_data.grid[i].actor, activity_data.grid[ i + num_cols ].actor ) then
				local cross_location = 
				{
					x = ((activity_data.grid[i].x + activity_data.grid[i + num_cols].x) / 2) + grid_cross_offset.x;
					y = ((activity_data.grid[i].y + activity_data.grid[i + num_cols].y) / 2) + grid_cross_offset.y;
				}
				crosses[cross_num] = scene:Spawn( get_cross_spec( cross_num ) )
				crosses[cross_num]:JumpToPoint( cross_location );
				cross_num = cross_num + 1;
			end
		end
	end
	flo:SetMode(MODE.CUTSCENE);
	help_panel_say_raw(scene:grabstring("check_display_text"));
	coroutine.yield(RESUME.ON_CLICK);
	flo:SetMode(MODE.FOLLOWCLICKS);
	if game:Get("activity_mode") == 1 then
		help_panel_say_raw("");
	else
		show_help_text();
	end
	for i = 1, cross_num-1 do
		crosses[i]:Expire();
	end
end

panelStartPos = { x = 850, y = 31 };
panelEndPos = { x = 120, y = 31 };
panelSpeed = 0.03;
panelCurrentPos = panelEndPos;

function DoTransition()
	panel:JumpToPoint(panelEndPos);
	sfx:PlaySFX("audio/sfx/panel_slide.ogg");
	
	while ( panelCurrentPos.x < panelStartPos.x ) do
		local panelXDiff = panelCurrentPos.x;
		panelCurrentPos = { x = panelCurrentPos.x + panelSpeed * ( panelStartPos.x - panelEndPos.x ), y = panelCurrentPos.y + panelSpeed * ( panelStartPos.y - panelEndPos.y ) };
		panelXDiff = panelCurrentPos.x - panelXDiff;
		
		for i,v in pairs(active_clothes_table) do
			move_actor_x(v, panelXDiff);
		end
		
		for i,v in pairs(active_peg_table) do
			move_actor_x(v, panelXDiff);
		end
		
		panel:JumpToPoint( panelCurrentPos );
		delay(1);
	end
	
	delay(30);
	
	sfx:PlaySFX("audio/sfx/panel_slide.ogg");

	while ( panelCurrentPos.x > panelEndPos.x ) do
		panelCurrentPos = { x = panelCurrentPos.x + panelSpeed * ( panelEndPos.x - panelStartPos.x ), y = panelCurrentPos.y + panelSpeed * ( panelEndPos.y - panelStartPos.y ) };
		panel:JumpToPoint( panelCurrentPos );
		delay(1);
	end
	
	panelCurrentPos = panelEndPos;
	panel:JumpToPoint( panelCurrentPos );
end

function next_activity(flo)	
	local activityNum = game:Get("mg_clothing_activity_num");
	local activityRound = game:Get("mg_clothing_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	local activityMode = game:Get("activity_mode") == 1;
	
	if not activityMode and roundComplete then	
		goto_scene(flo, "m1_dress");	
	else
		if not activityMode then
			scene.NEXT_ACTIVITY_BUTTON:Expire();
		end
		
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
		
		if IsCheatMode() then
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end;
		
		if scene.DISPLAY_COMPLETE then
			scene.DISPLAY_COMPLETE:Expire();
		end
		
		-- load new puzzle
		panelCurrentPos = panelEndPos;		
		DoTransition();
		
		if activityMode then
			spawn_button(start_button_spec);
			move_actor_y(scene.START_BUTTON, -hud_lower_offset);
		end
		
		if not activityMode then
			show_help_text();
		end
		
		if not activityMode then
			-- load new puzzle		
			setup_activity();
		else
			kill_activity_timer();
		end
	end
end;

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function show_hint(flo)
	flo:SetMode(MODE.CUTSCENE);
	help_panel_say_raw( scene:grabstring( "hint_" .. tostring( game:Get( "mg_clothing_activity_num" ) ) .. "_" .. tostring( game:Get( "mg_clothing_activity_round" ) ) ) );
	coroutine.yield(RESUME.ON_CLICK);
	show_help_text();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		MET_Count("HintsClicked");
		flo:StartProc(show_hint);
	end;
}

function show_help_text()
	local activityNum = game:Get("mg_clothing_activity_num");
	local activityRound = game:Get("mg_clothing_activity_round");
	help_panel_say_raw(
		scene:grabstring("help_" .. tostring(activityNum) .. "_" .. tostring(activityRound)));
end

function show_activity_complete_text()
	local activityNum = game:Get("mg_clothing_activity_num");
	local activityRound = game:Get("mg_clothing_activity_round");
	help_panel_say_raw(
		scene:grabstring("activity_complete_" .. tostring(activityNum) .. "_" .. tostring(activityRound)));
end

function activity_passed(flo)
	stop_activity_timer(); -- quest/activity_mode/activity_timer.lua
	local activityNum = game:Get("mg_clothing_activity_num");
	local activityRound = game:Get("mg_clothing_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	local activityMode = game:Get("activity_mode") == 1;
	
	-- remove meshes for all items
	local numItems = table.getn(activity_data.clothes);
	for i = 1, numItems do
		activity_data.grid[i].actor:DumpZone();
	end
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	if not activityMode then
		scene.HINT_BUTTON:Expire();
	end
	
	scene.CHECK_DISPLAY_BUTTON:Expire();
	
	scene.BACK_BUTTON:Expire();
	
	if not activityMode then
		spawn_button(next_activity_button_spec);
		scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
	
		show_activity_complete_text();
	
		if roundComplete then	
			if activityRound == 1 then		-- round == 2
				game:Set("mg_clothing_activity_round", 2);
				game:Set("mg_clothing_activity_num", 1);
			elseif activityRound == 2 then-- round == 3
				game:Set("mg_clothing_activity_round", 3);
				game:Set("mg_clothing_activity_num", 1);
			elseif activityRound == 3 then-- round == 4
				game:Set("mg_clothing_activity_round", 4);
				game:Set("mg_clothing_activity_num", 1);
			else -- round == 5
				game:Set("mg_clothing_activity_round", 5);
				game:Set("mg_clothing_activity_num", 1);
			end
		else
			game:Set("mg_clothing_activity_num", activityNum + 1);
		end
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_display.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	if activityMode then
		activityNum = game:Get("activity_mode_level");
		activityRound = table.getn(round_num);
		roundComplete = activityNum == round_num[activityRound];
		
		--if roundComplete then
		--	game:EarnAward("avenue-flo_clothingdisplay");
		--end
	
		show_activity_results();
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m1_dress");
end;

game_controller_spec = 
{
	name = "GAME_CONTROLLER";
}

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

active_clothes_table = {};
active_peg_table = {};
panel = nil;

function get_panel_spec()
	return
	{
		name = "panel" .. tostring( game:Get( "mg_clothing_activity_round" ) ) .. tostring( game:Get( "mg_clothing_activity_num" ) );	
		halo = "";
		gfx = { image = "panel" };
		
		command = function(actor)
			actor:SetDepthValue( clothes_depth - 2 );
			actor:JumpToPoint( panelEndPos );
			actor:SetAlpha(1);			
		end
	}
end

function swing_a_bit(actor)
	local swing_count = 3;
	local swing_delay = 60;
	local direction = 1;
	
	while swing_delay > 0 do
		actor:SetRadians(math.sin(((swing_delay*swing_delay)*0.005)/(math.pi))*0.1);
		swing_delay = swing_delay - 1;
		delay(1);
	end
	actor:SetRadians(0);
end;

function get_clothing_spec(_name, _type, _colour, _pattern, _index, _scale)
	return
	{
		--name = clothing_type_table[_type].."_"..clothing_colour_table[_colour].."_"..clothing_pattern_table[_pattern];
		name = "~" .. _name;
		--halo = clothing_type_table[_type].name;
		gfx = { image = clothing_type_table[_type].name.."_"..clothing_colour_table[_colour].."_"..clothing_pattern_table[_pattern] };
		hotspot = clothing_type_table[_type].hotspot;
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_HALO_NO_SCALE);
			actor.grid_index = _index;
			actor:SetDepthValue(clothes_depth);
			actor:JumpToPoint(activity_data.grid[_index]);
			actor:SetPointAtCursor("cursor_open_hand");
			actor.moving = false;
			actor:ModifySaySpec {
				color = { a = 1, r = 1, g = 1, b = 1 },
				x = 0, y = 100,
				w = 120, h = 100, 
				outline_size = 2, 
				bubble = false,
				anchor = ANCHOR.CENTER};
			
			actor.type = clothing_type_table[_type].name;
			actor.colour = clothing_colour_table[_colour];
			actor.pattern = clothing_pattern_table[_pattern];
			actor:SetScale(_scale);
			activity_data.grid[_index].actor = actor;
			
			actor.on_click = function(flo, clothing)
				if actor.moving == false then
					if moving_actor == nil then -- pick up the item
						local clickedAt = scene:GetClickedAtScreen();
						local actorPos = actor:GetPosition();
						actor.moving = true;
						actor.movingx = actorPos.x - clickedAt.x;
						actor.movingy = actorPos.y - clickedAt.y;
						actor:SetDepthValue(clothes_moving_depth);
						actor:StartProc(move_item);
						--actor:SayRaw("moving");
						moving_actor = actor;
						actor:DumpZone();
						scene.GAME_CONTROLLER:StartProc(moving_item);
						sfx:PlaySFX("audio/sfx/pickup_clothing.ogg");
						actor:SetRadians(0);
						actor:SetPointAtCursor("cursor_closed_hand");
						scene.BACKGROUND_MESH:LoadZone("background");
					--[[
					else -- swap the item
						-- swap the grid indexes of the actors
						local temp = moving_actor.grid_index;
						moving_actor.grid_index = actor.grid_index;
						actor.grid_index = temp;
						
						-- swap the actors in the grid
						activity_data.grid[actor.grid_index].actor = actor;
						activity_data.grid[moving_actor.grid_index].actor = moving_actor;
						
						-- move this actor (moving_actor handled elsewhere)
						actor:JumpToPoint(activity_data.grid[actor.grid_index]);
					--]]
					end
					return RESPONSE.IGNORE;
				else
					stop_moving(actor);
				end
			end
			
			actor.on_release = function(flo, clothing)
				-- swap the grid indexes of the actors
				if moving_actor ~= nil then
					local temp = moving_actor.grid_index;
					moving_actor.grid_index = actor.grid_index;
					actor.grid_index = temp;
					
					-- swap the actors in the grid
					activity_data.grid[actor.grid_index].actor = actor;
					activity_data.grid[moving_actor.grid_index].actor = moving_actor;
					
					-- move this actor
					actor:JumpToPoint(activity_data.grid[actor.grid_index]);
					actor:StartProc(swing_a_bit);
					
					-- move the moving actor
					stop_moving(moving_actor);
					moving_actor = nil;
					--scene.DEBUG_OUT:SayRaw("on_release");
				end
			end
			
			actor.point_at_fn = function(flo, enter)
				--if moving_actor and moving_actor ~= actor then
					if enter then
						
						if not (actor:GetScaleX() > activity_data.scale) then
							actor:SetScale(activity_data.upscale);
							sfx:PlaySFX("audio/sfx/clothing_rollover.ogg");
							--scene.DEBUG_OUT:SayRaw("enter " .. actor:GetScaleX());
							--scene.DEBUG_OUT:SayRaw("enter");
						end
					elseif actor.moving == false then
						actor:SetScale(activity_data.scale);
						--sfx:PlaySFX("audio/sfx/sfx_typing_02.ogg");
						--scene.DEBUG_OUT:SayRaw("exit");
						--actor:JumpToPoint(activity_data.grid[actor.grid_index]);
					end
				--end
			end
		end
	}
end;

function spawn_peg(_name, _index)
	return scene:Spawn
	{
		name = _name;
		gfx = { image = "clothing_peg" };
		
		command = function(actor)
			actor:SetDepthValue(clothes_depth+1);
			local postion = { x = activity_data.grid[_index].x-3, y = activity_data.grid[_index].y-8 };
			actor:JumpToPoint(postion);
		end;
	};
end;

function spawn_clothes()
	--expire active clothes
	-- panel slides off
	scene:SetMode(MODE.CUTSCENE);
	
	if table.getn(active_clothes_table) > 0 then
		--sfx:PlaySFX("audio/sfx/panel_slide.ogg");
		
		for i,v in pairs(active_clothes_table) do
			v:Expire();
		end
		for i,v in pairs(active_peg_table) do
			v:Expire();
		end
		active_clothes_table = {};
		active_peg_table = {};
		
		delay(60);
	end
		
	local round = game:Get("mg_clothing_activity_round");
	local activity_num = game:Get("mg_clothing_activity_num");
	local activityMode = game:Get("activity_mode") == 1;
	
	if activityMode then
		activity_num = game:Get("activity_mode_level");
		round = table.getn(round_num);
	end
	
	activity_data = items[round][activity_num];
	
	if activity_data then
		local numItems = table.getn(activity_data.clothes);
		local num_cols = activity_data.columns;
		local num_rows = numItems / num_cols;
		
		activity_data.grid = { };
		
		for i = 1, numItems do
			local row = math.floor( ( i - 1 ) / num_cols );
			local col = fmod( ( i - 1 ), num_cols );
			local grid_entry = { x = activity_data.grid_x + (col*activity_data.grid_w), y = activity_data.grid_y + (row * activity_data.grid_h) };
			table.insert(activity_data.grid, grid_entry);
		end
		
		for i,v in pairs(activity_data.clothes) do
			local actor = spawn_peg("PEG_" .. tostring(activity_num) .. tostring(i), i);
			table.insert(active_peg_table, actor);
		end
		
		for i,v in pairs(activity_data.clothes) do
			local clothing_name = tostring(activity_num) .. tostring(i);
			local clothes_spec = get_clothing_spec(clothing_name, v.TYPE, v.COLOUR, v.PATTERN, i, activity_data.scale);
			local actor = scene:Spawn(clothes_spec);
			table.insert(active_clothes_table, actor);
			sfx:PlaySFX("audio/sfx/new_display.ogg");
			delay(15);
			--actor:SayRaw(clothing_name);
			--actor:SayRaw(tostring(table.getn(activity_data.clothes)));
			--local row = math.floor( ( i - 1 ) / ( activity_data.columns ) ) + 1;
			--local column = fmod( ( i - 1 ), activity_data.columns ) + 1
			--actor:SayRaw(tostring(row) .. tostring(column));
		end
		
		-- now load all the meshes for the clothing items so they can be dragged around
		for i,v in pairs(active_clothes_table) do
			v:LoadZone(v.type);
		end
	end
	scene:SetMode(MODE.FOLLOWCLICKS);
end;

function move_item(actor)
	while actor.moving do
		local cursorPos = scene:GetCursorPos();
		actor:JumpToPoint { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };
		delay(1);
	end;
end;

function clothes_different(actor1, actor2)
	local different = actor1.type ~= actor2.type and actor1.colour ~= actor2.colour;
	
	-- special case for patterns as solid adjacent patterns are okay
	if different and (actor1.pattern ~= "solid" or actor2.pattern ~= "solid") then
		different  = actor1.pattern ~= actor2.pattern;
	end
	
	--actor1:SayRaw("tested");
	--coroutine.yield(RESUME.ON_CLICK);
	--actor2:SayRaw("tested");
	--coroutine.yield(RESUME.ON_CLICK);
	--actor1:SayRaw("");
	--actor2:SayRaw("");
	
	return different
end

function check_solved()
	local numItems = table.getn(activity_data.clothes);
	local num_cols = activity_data.columns;
	local num_rows = numItems / num_cols;
	
	-- start at the top left of the grid, checking left and down for items that aren't different
	for i = 1, numItems do
		local row = math.floor( ( i - 1 ) / num_cols ) + 1;
		local col = fmod( ( i - 1 ), num_cols ) + 1;
		
		--help_panel_say_raw("row = " .. tostring(row) .. ", col = " .. tostring(col));
		--coroutine.yield(RESUME.ON_CLICK);
		
		-- check right if not at the end
		if col <  num_cols then
			if not clothes_different( activity_data.grid[i].actor, activity_data.grid[ i + 1 ].actor ) then
				--help_panel_say_raw("cols return false");
				return false;
			end
		end
		-- check down if not at the bottom
		if row < num_rows then
			if not clothes_different( activity_data.grid[i].actor, activity_data.grid[ i + num_cols ].actor ) then
				--help_panel_say_raw("rows return false");
				return false;
			end
		end
	end
	
	return true;
end;

function stop_moving(actor)
	actor:JumpToPoint(activity_data.grid[moving_actor.grid_index]);
	actor:SetDepthValue(clothes_depth);
	actor.moving = false;
	sfx:PlaySFX("audio/sfx/drop_clothing.ogg");
	--actor:SayRaw("not moving");
	actor:SetPointAtCursor("cursor_open_hand");
	scene.BACKGROUND_MESH:DumpZone();
	actor:LoadZone(actor.type);
end

-- running as GAME_CONTROLLER proc whilst actor is moving
function moving_item(actor)
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	scene.FLO:SetMode(MODE.CUTSCENE);
	coroutine.yield(RESUME.NOW);
	--delay(2);
	
	-- if we didn't click on another clothing item, put us back
	if moving_actor ~= nil then
		stop_moving(moving_actor);
		moving_actor:SetScale(activity_data.scale);
		moving_actor:StartProc(swing_a_bit);
		moving_actor = nil;	
	end;
	
	-- check if we've solved the puzzle
	if check_solved() then
		scene.FLO:StartProc(activity_passed);
	end
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

check_display_button_spec = 
{
	name = "CHECK_DISPLAY_BUTTON";
	text = "check_display";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 560 };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, button)
		flo:StartProc(CheckDisplay);
	end;
}

background_mesh_spec = 
{
	name = "BACKGROUND_MESH";
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_closed_hand");
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_activity2.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		delay(1); -- so any variables can be set properly (i.e. activity_mode)
		local activityMode = game:Get("activity_mode") == 1;
		game:ClearInvUsage();
		
		fade_scene_up(true);
		lower_hud();
		
		if activityMode then
			spawn_button(start_button_spec);
		end
		
		spawn_help_panel();
		
		if IsCheatMode() then
			-- testing data
			if not activityMode then
				spawn_button(pass_activity_button_spec);
			end
		end
		
		-- set up for initial play
		if game:Get("mg_clothing_activity_num") < 1 then
			game:Set("mg_clothing_activity_num", 1);
		end
		
		if game:Get("mg_clothing_activity_round") < 1 then
			game:Set("mg_clothing_activity_round", 1);
		end
		
		-- unlock clothing in activity mode
		if game:Get("clothing_unlocked") < 1 then
			game:Set("clothing_unlocked", 1);
			game:Set("activity_unlocked", 1);
		end
		
		panel = scene:Spawn( get_panel_spec() );
		
		if not activityMode then
			setup_activity();
		else
			help_panel_activity_mode_intro();
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		-- load pieces
		"pieces",
		"clothing_pants1",
		"clothing_pants2",
		"clothing_pants3",
		"clothing_shirt1",
		"clothing_shirt2",
		"clothing_shirt3",
		"clothing_skirt1",
		"clothing_skirt2",
		"clothing_skirt3",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		game_controller_spec,
		flo_spec, -- the main actor
		scene_setup,
		background_mesh_spec,
	};
};
